define(['marionette'], function(Marionette) {
    'use strict';
    // Render a template with data. The `template` parameter is
    // passed to the `TemplateCache` object to retrieve the
    // template function. Override this method to provide your own
    // custom rendering and template handling for all of Marionette.
    Marionette.Renderer.render = function(template, data) {

        if (!template) {
            var error = new Error("Cannot render the template since it's false, null or undefined.");
            error.name = 'TemplateNotFoundError';
            throw error;
        }

        var templateFunc;
        if (typeof template === 'function') {
            templateFunc = template;
        }
        else {
            //
            templateFunc = _.template(template);
        }

        return templateFunc(data);
    };
});
